// Bar-graph mode using 74HC595
// Arduino pins
const int dataPin  = 11; // DS (74HC595 pin 14)
const int clockPin = 13; // SH_CP (74HC595 pin 11)
const int latchPin = 10; // ST_CP (74HC595 pin 12)

// Optional: push button to toggle behavior (not required)
const int buttonPin = 2; // use INPUT_PULLUP if you wire a button

const int STEP_DELAY = 180; // ms between steps

// Write one byte to the 74HC595 (LSB -> Q0)
void shiftWrite(byte value) {
  digitalWrite(latchPin, LOW);
  // Use LSBFIRST so bit0 -> Q0 (LED1), bit7 -> Q7 (LED8)
  shiftOut(dataPin, clockPin, LSBFIRST, value);
  digitalWrite(latchPin, HIGH);
}

void setup() {
  pinMode(dataPin, OUTPUT);
  pinMode(clockPin, OUTPUT);
  pinMode(latchPin, OUTPUT);

  // Optional button
  pinMode(buttonPin, INPUT_PULLUP);

  // Clear outputs
  shiftWrite(0x00);
}

void loop() {
  // Grow from 0 to 8 LEDs
  for (int i = 1; i <= 8; i++) {
    byte pattern = 0;
    for (int b = 0; b < i; b++) {
      pattern |= (1 << b); // set bit b (LSB = LED1)
    }
    shiftWrite(pattern);
    delay(STEP_DELAY);
    // If button pressed, you could break/modify behavior here (optional)
  }

  // Pause at full
  delay(300);

  // Shrink from 8 down to 0
  for (int i = 8; i >= 0; i--) {
    byte pattern = 0;
    for (int b = 0; b < i; b++) {
      pattern |= (1 << b);
    }
    shiftWrite(pattern);
    delay(STEP_DELAY);
  }

  // Optional pause
  delay(300);
}
